/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functions;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionWithDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithFirstDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithIntegral;

public class MathFunctionUtil {
    public static double H = 1.0E-6;
    private static final double[] Cg = new double[]{0.0, 0.17267316464601143, 0.5, 0.8273268353539885, 1.0};
    private static final double[] Wg = new double[]{0.05, 0.2722222222222222, 0.35555555555555557, 0.2722222222222222, 0.05};
    public static int NUMINTERVALS = 1024;

    private MathFunctionUtil() {
    }

    private static double[] fixBounds(MathFunction func, double a, double b, int numIntervals) {
        double x;
        double h = (b - a) / (double)numIntervals;
        for (x = b; 0.0 == func.evaluate(x) && x > a; x -= h) {
        }
        if (x < b) {
            b = x + h;
        }
        for (x = a; 0.0 == func.evaluate(x) && x < b; x += h) {
        }
        if (x > a) {
            a = x - h;
        }
        double[] D = new double[]{a, b};
        return D;
    }

    public static double derivative(MathFunction func, double x) {
        if (func instanceof MathFunctionWithFirstDerivative) {
            return ((MathFunctionWithFirstDerivative)func).derivative(x);
        }
        if (func instanceof MathFunctionWithDerivative) {
            return ((MathFunctionWithDerivative)func).derivative(x, 1);
        }
        return MathFunctionUtil.finiteCenteredDifferenceDerivative(func, x, H);
    }

    public static double derivative(MathFunction func, double x, int n) {
        if (n == 0) {
            return func.evaluate(x);
        }
        if (n == 1) {
            return MathFunctionUtil.derivative(func, x);
        }
        if (func instanceof MathFunctionWithDerivative) {
            return ((MathFunctionWithDerivative)func).derivative(x, n);
        }
        if (n % 2 == 0) {
            return MathFunctionUtil.finiteCenteredDifferenceDerivative(func, x, n, H);
        }
        return MathFunctionUtil.finiteDifferenceDerivative(func, x, n, H);
    }

    public static double finiteDifferenceDerivative(MathFunction func, double x, int n, double h) {
        if (n < 0) {
            throw new IllegalArgumentException("n must not be negative");
        }
        if (n == 0) {
            return func.evaluate(x);
        }
        double err = Math.pow(h, 1.0 / (double)n);
        double[] values2 = new double[n + 1];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = func.evaluate(x + (double)i * err);
        }
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < n - j; ++i) {
                values2[i] = values2[i + 1] - values2[i];
            }
        }
        return values2[0] / h;
    }

    public static double finiteCenteredDifferenceDerivative(MathFunction func, double x, double h) {
        double fplus = func.evaluate(x + h);
        double fminus = func.evaluate(x - h);
        return (fplus - fminus) / (2.0 * h);
    }

    public static double finiteCenteredDifferenceDerivative(MathFunction func, double x, int n, double h) {
        if (n < 0) {
            throw new IllegalArgumentException("n must not be negative");
        }
        if (n == 0) {
            return func.evaluate(x);
        }
        if (n % 2 == 1) {
            throw new IllegalArgumentException("n must be even");
        }
        double err = Math.pow(h, 1.0 / (double)n);
        return MathFunctionUtil.finiteDifferenceDerivative(func, x - (double)n * err / 2.0, n, h);
    }

    public static double[][] removeNaNs(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException();
        }
        int numNaNs = 0;
        for (int i = 0; i < x.length; ++i) {
            if (!Double.isNaN(x[i]) && !Double.isNaN(y[i])) continue;
            ++numNaNs;
        }
        if (numNaNs == 0) {
            return new double[][]{x, y};
        }
        double[] nx = new double[x.length - numNaNs];
        double[] ny = new double[y.length - numNaNs];
        int j = 0;
        for (int i = 0; i < x.length; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y[i])) continue;
            nx[j] = x[i];
            ny[j++] = y[i];
        }
        return new double[][]{nx, ny};
    }

    public static double integral(MathFunction func, double a, double b) {
        if (func instanceof MathFunctionWithIntegral) {
            return ((MathFunctionWithIntegral)func).integral(a, b);
        }
        return MathFunctionUtil.simpsonIntegral(func, a, b, NUMINTERVALS);
    }

    public static double simpsonIntegral(MathFunction func, double a, double b, int numIntervals) {
        if (numIntervals % 2 != 0) {
            throw new IllegalArgumentException("numIntervals must be an even number");
        }
        if (Double.isInfinite(a) || Double.isInfinite(b) || Double.isNaN(a) || Double.isNaN(b)) {
            throw new IllegalArgumentException("a and b must not be infinite or NaN");
        }
        if (b < a) {
            throw new IllegalArgumentException("b < a");
        }
        if (a == b) {
            return 0.0;
        }
        double[] D = MathFunctionUtil.fixBounds(func, a, b, numIntervals);
        a = D[0];
        b = D[1];
        double h = (b - a) / (double)numIntervals;
        double h2 = 2.0 * h;
        int m = numIntervals / 2;
        double sum = 0.0;
        for (int i = 0; i < m - 1; ++i) {
            double x = a + h + h2 * (double)i;
            sum += 4.0 * func.evaluate(x) + 2.0 * func.evaluate(x + h);
        }
        return (sum += func.evaluate(a) + func.evaluate(b) + 4.0 * func.evaluate(b - h)) * h / 3.0;
    }

    public static double gaussLobatto(MathFunction func, double a, double b, double tol) {
        double h;
        double r1;
        if (b < a) {
            throw new IllegalArgumentException("b < a");
        }
        if (Double.isInfinite(a) || Double.isInfinite(b) || Double.isNaN(a) || Double.isNaN(b)) {
            throw new IllegalArgumentException("a or b is infinite or NaN");
        }
        if (a == b) {
            return 0.0;
        }
        double r0 = MathFunctionUtil.simpleGaussLob(func, a, b);
        if (Math.abs(r0 - (r1 = MathFunctionUtil.simpleGaussLob(func, a, a + (h = (b - a) / 2.0)) + MathFunctionUtil.simpleGaussLob(func, a + h, b))) <= tol) {
            return r1;
        }
        return MathFunctionUtil.gaussLobatto(func, a, a + h, tol) + MathFunctionUtil.gaussLobatto(func, a + h, b, tol);
    }

    private static double simpleGaussLob(MathFunction func, double a, double b) {
        if (a == b) {
            return 0.0;
        }
        double h = b - a;
        double sum = 0.0;
        for (int i = 0; i < 5; ++i) {
            sum += Wg[i] * func.evaluate(a + h * Cg[i]);
        }
        return h * sum;
    }

    public static double gaussLobatto(MathFunction func, double a, double b, double tol, double[][] T) {
        if (b < a) {
            throw new IllegalArgumentException("b < a");
        }
        if (a == b) {
            T[0] = new double[1];
            T[1] = new double[1];
            T[0][0] = a;
            T[1][0] = 0.0;
            return 0.0;
        }
        int n = 1;
        T[0] = new double[n];
        T[1] = new double[n];
        T[0][0] = a;
        T[1][0] = 0.0;
        int[] s = new int[]{0};
        double res = MathFunctionUtil.innerGaussLob(func, a, b, tol, T, s);
        n = s[0] + 1;
        double[] temp = new double[n];
        System.arraycopy(T[0], 0, temp, 0, n);
        T[0] = temp;
        temp = new double[n];
        System.arraycopy(T[1], 0, temp, 0, n);
        T[1] = temp;
        return res;
    }

    private static double innerGaussLob(MathFunction func, double a, double b, double tol, double[][] T, int[] s) {
        double h;
        double r1;
        double r0 = MathFunctionUtil.simpleGaussLob(func, a, b);
        if (Math.abs(r0 - (r1 = MathFunctionUtil.simpleGaussLob(func, a, a + (h = (b - a) / 2.0)) + MathFunctionUtil.simpleGaussLob(func, a + h, b))) <= tol) {
            s[0] = s[0] + 1;
            int len = s[0];
            if (len >= T[0].length) {
                double[] temp = new double[2 * len];
                System.arraycopy(T[0], 0, temp, 0, len);
                T[0] = temp;
                temp = new double[2 * len];
                System.arraycopy(T[1], 0, temp, 0, len);
                T[1] = temp;
            }
            T[0][len] = b;
            T[1][len] = r1;
            return r1;
        }
        return MathFunctionUtil.innerGaussLob(func, a, a + h, tol, T, s) + MathFunctionUtil.innerGaussLob(func, a + h, b, tol, T, s);
    }
}

