/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class KolmogorovSmirnovPlusDist
extends ContinuousDistribution {
    protected int n;

    public KolmogorovSmirnovPlusDist(int n) {
        this.setN(n);
    }

    public double density(double x) {
        return KolmogorovSmirnovPlusDist.density(this.n, x);
    }

    public double cdf(double x) {
        return KolmogorovSmirnovPlusDist.cdf(this.n, x);
    }

    public double barF(double x) {
        return KolmogorovSmirnovPlusDist.barF(this.n, x);
    }

    public double inverseF(double u) {
        return KolmogorovSmirnovPlusDist.inverseF(this.n, u);
    }

    private static double dclem(int n, double x, double EPS) {
        return (KolmogorovSmirnovPlusDist.cdf(n, x + EPS) - KolmogorovSmirnovPlusDist.cdf(n, x - EPS)) / (2.0 * EPS);
    }

    public static double density(int n, double x) {
        double D2;
        if (n <= 0) {
            throw new IllegalArgumentException("Calling kolmogorovSmirnovPlus with n < 1");
        }
        if (x <= 0.0 || x >= 1.0) {
            return 0.0;
        }
        if (n == 1) {
            return 1.0;
        }
        double EPS = 0.01;
        double D1 = KolmogorovSmirnovPlusDist.dclem(n, x, 0.01);
        double RES = D1 + (D1 - (D2 = KolmogorovSmirnovPlusDist.dclem(n, x, 0.02))) / 3.0;
        if (RES < 0.0) {
            return 0.0;
        }
        return RES;
    }

    public static double cdf(int n, double x) {
        if (n <= 0) {
            throw new IllegalArgumentException("Calling kolmogorovSmirnovPlus with n < 1");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0 || (double)n * x * x >= 25.0) {
            return 1.0;
        }
        if (n == 1) {
            return x;
        }
        double NXPARAM = 6.5;
        int NPARAM = 4000;
        double Sum2 = 0.0;
        double LogCom = Math.log(n);
        if ((double)n * x <= 6.5) {
            double EPSILON = Double.MIN_NORMAL;
            int jmax = (int)((double)n * x);
            int Sign = -1;
            for (int j = 1; j <= jmax; ++j) {
                double jreal = j;
                double Njreal = n - j;
                double q = jreal / (double)n - x;
                if (-q > Double.MIN_NORMAL) {
                    double term = LogCom + jreal * Math.log(-q) + (Njreal - 1.0) * Math.log1p(-q);
                    Sum2 += (double)Sign * Math.exp(term);
                }
                Sign = -Sign;
                LogCom += Math.log(Njreal / (double)(j + 1));
            }
            return (Sum2 += Math.exp((double)(n - 1) * Math.log1p(x))) * x;
        }
        if (n <= 4000) {
            int jmax = (int)((double)n * (1.0 - x));
            if (1.0 - x - (double)jmax / (double)n <= 0.0) {
                --jmax;
            }
            for (int j = 1; j <= jmax; ++j) {
                double jreal = j;
                double Njreal = n - j;
                double q = jreal / (double)n + x;
                double term = LogCom + (jreal - 1.0) * Math.log(q) + Njreal * Math.log1p(-q);
                Sum2 += Math.exp(term);
                LogCom += Math.log(Njreal / (jreal + 1.0));
            }
            Sum2 *= x;
            if (1.0 > x) {
                Sum2 += Math.exp((double)n * Math.log1p(-x));
            }
            return 1.0 - Sum2;
        }
        double term = 0.6666666666666666;
        double q = x * x * (double)n;
        Sum2 = 1.0 - Math.exp(-2.0 * q) * (1.0 - term * x * (1.0 - x * (1.0 - term * q) - term / (double)n * (0.2 - 1.2666666666666666 * q + term * q * q)));
        return Sum2;
    }

    private static double KSPlusbarAsymp(int n, double x) {
        double t = 6.0 * (double)n * x + 1.0;
        double z = t * t / (18.0 * (double)n);
        double v = 1.0 - (2.0 * z * z - 4.0 * z - 1.0) / (18.0 * (double)n);
        if (v <= 0.0) {
            return 0.0;
        }
        if ((v *= Math.exp(-z)) >= 1.0) {
            return 1.0;
        }
        return v;
    }

    static double KSPlusbarUpper(int n, double x) {
        double t;
        double term;
        double q;
        int j;
        double LogCom;
        if (n > 200000) {
            return KolmogorovSmirnovPlusDist.KSPlusbarAsymp(n, x);
        }
        int jmax = (int)((double)n * (1.0 - x));
        if (1.0 - x - (double)jmax / (double)n <= 0.0) {
            --jmax;
        }
        int jdiv = n > 3000 ? 2 : 3;
        double LOGJM = LogCom = Num.lnFactorial(n) - Num.lnFactorial(j) - Num.lnFactorial(n - j);
        double EPSILON = 1.0E-12;
        double Sum2 = 0.0;
        for (j = jmax / jdiv + 1; j <= jmax; ++j) {
            q = (double)j / (double)n + x;
            term = LogCom + (double)(j - 1) * Math.log(q) + (double)(n - j) * Math.log1p(-q);
            t = Math.exp(term);
            LogCom += Math.log((double)(n - j) / (double)(j + 1));
            if (t <= (Sum2 += t) * 1.0E-12) break;
        }
        LogCom = LOGJM + Math.log((double)(j + 1) / (double)(n - j));
        for (j = jmax / jdiv; j > 0; --j) {
            q = (double)j / (double)n + x;
            term = LogCom + (double)(j - 1) * Math.log(q) + (double)(n - j) * Math.log1p(-q);
            t = Math.exp(term);
            LogCom += Math.log((double)j / (double)(n - j + 1));
            if (t <= (Sum2 += t) * 1.0E-12) break;
        }
        Sum2 *= x;
        return Sum2 += Math.exp((double)n * Math.log1p(-x));
    }

    public static double barF(int n, double x) {
        if (n <= 0) {
            throw new IllegalArgumentException("Calling kolmogorovSmirnovPlus with n < 1");
        }
        if (x <= 0.0) {
            return 1.0;
        }
        if (x >= 1.0 || (double)n * x * x >= 365.0) {
            return 0.0;
        }
        if (n == 1) {
            return 1.0 - x;
        }
        double NXPARAM = 6.5;
        int NPARAM = 4000;
        int NASYMP = 200000;
        if ((double)n * x <= 6.5) {
            return 1.0 - KolmogorovSmirnovPlusDist.cdf(n, x);
        }
        if (n >= 200000) {
            return KolmogorovSmirnovPlusDist.KSPlusbarAsymp(n, x);
        }
        if (n <= 4000 || (double)n * x * x > 1.0) {
            return KolmogorovSmirnovPlusDist.KSPlusbarUpper(n, x);
        }
        return KolmogorovSmirnovPlusDist.KSPlusbarAsymp(n, x);
    }

    public static double inverseF(int n, double u) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u must be in [0,1]");
        }
        if (u == 1.0) {
            return 1.0;
        }
        if (u == 0.0) {
            return 0.0;
        }
        Function f = new Function(n, u);
        return RootFinder.brentDekker(0.0, 1.0, f, 1.0E-8);
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.n = n;
        this.supportA = 0.0;
        this.supportB = 1.0;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.n};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : n = " + this.n;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double u;

        public Function(int n, double u) {
            this.n = n;
            this.u = u;
        }

        public double evaluate(double x) {
            return this.u - KolmogorovSmirnovPlusDist.cdf(this.n, x);
        }
    }
}

