/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.randvar.BetaGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class BetaRejectionLoglogisticGen
extends BetaGen {
    private RandomStream auxStream;
    private static final int bb = 0;
    private static final int bc = 1;
    private double am;
    private double bm;
    private double al;
    private double alnam;
    private double be;
    private double ga;
    private double si;
    private double rk1;
    private double rk2;

    public BetaRejectionLoglogisticGen(RandomStream s, RandomStream aux, double alpha, double beta) {
        super(s, null);
        this.auxStream = aux;
        this.setParams(alpha, beta, 0.0, 1.0);
        this.init();
    }

    public BetaRejectionLoglogisticGen(RandomStream s, double alpha, double beta) {
        this(s, s, alpha, beta);
    }

    public BetaRejectionLoglogisticGen(RandomStream s, RandomStream aux, double alpha, double beta, double a, double b) {
        super(s, null);
        this.auxStream = aux;
        this.setParams(alpha, beta, a, b);
        this.init();
    }

    public BetaRejectionLoglogisticGen(RandomStream s, double alpha, double beta, double a, double b) {
        this(s, s, alpha, beta, a, b);
    }

    public BetaRejectionLoglogisticGen(RandomStream s, RandomStream aux, BetaDist dist) {
        super(s, dist);
        this.auxStream = aux;
        if (dist != null) {
            this.setParams(dist.getAlpha(), dist.getBeta(), dist.getA(), dist.getB());
        }
        this.init();
    }

    public BetaRejectionLoglogisticGen(RandomStream s, BetaDist dist) {
        this(s, s, dist);
    }

    public RandomStream getAuxStream() {
        return this.auxStream;
    }

    private void init() {
        if (this.p > 1.0 && this.q > 1.0) {
            this.gen = 0;
            this.am = this.p < this.q ? this.p : this.q;
            this.bm = this.p > this.q ? this.p : this.q;
            this.al = this.am + this.bm;
            this.be = Math.sqrt((this.al - 2.0) / (2.0 * this.p * this.q - this.al));
            this.ga = this.am + 1.0 / this.be;
        } else {
            this.gen = 1;
            this.am = this.p > this.q ? this.p : this.q;
            this.bm = this.p < this.q ? this.p : this.q;
            this.al = this.am + this.bm;
            this.alnam = this.al * Math.log(this.al / this.am) - 1.386294361;
            this.be = 1.0 / this.bm;
            this.si = 1.0 + this.am - this.bm;
            this.rk1 = this.si * (0.013888889 + 0.041666667 * this.bm) / (this.am * this.be - 0.77777778);
            this.rk2 = 0.25 + (0.5 + 0.25 / this.si) * this.bm;
        }
    }

    public double nextDouble() {
        double X2 = 0.0;
        RandomStream stream = this.stream;
        block0 : switch (this.gen) {
            case 0: {
                double t;
                double u2;
                double z;
                double w;
                double u1;
                double v;
                double r;
                double s;
                do {
                    u1 = stream.nextDouble();
                    u2 = stream.nextDouble();
                    stream = this.auxStream;
                } while ((s = this.am + (r = this.ga * (v = this.be * Math.log(u1 / (1.0 - u1))) - 1.386294361) - (w = this.am * Math.exp(v))) + 2.609437912 < 5.0 * (z = u1 * u1 * u2) && s < (t = Math.log(z)) && r + this.al * Math.log(this.al / (this.bm + w)) < t);
                X2 = BetaRejectionLoglogisticGen.equalsDouble(this.am, this.p) ? w / (this.bm + w) : this.bm / (this.bm + w);
                break;
            }
            case 1: {
                double w;
                while (true) {
                    double v;
                    double z;
                    double u1 = stream.nextDouble();
                    double u2 = stream.nextDouble();
                    stream = this.auxStream;
                    if (u1 < 0.5) {
                        double y = u1 * u2;
                        z = u1 * y;
                        if (0.25 * u2 - y + z >= this.rk1) continue;
                        v = this.be * Math.log(u1 / (1.0 - u1));
                        if (v > 80.0) {
                            if (this.alnam < Math.log(z)) continue;
                            X2 = BetaRejectionLoglogisticGen.equalsDouble(this.am, this.p) ? 1.0 : 0.0;
                            break block0;
                        }
                        w = this.am * Math.exp(v);
                        if (this.al * (Math.log(this.al / (this.bm + w)) + v) - 1.386294361 < Math.log(z)) continue;
                        X2 = !BetaRejectionLoglogisticGen.equalsDouble(this.am, this.p) ? this.bm / (this.bm + w) : w / (this.bm + w);
                        break block0;
                    }
                    z = u1 * u1 * u2;
                    if (z < 0.25) {
                        v = this.be * Math.log(u1 / (1.0 - u1));
                        if (v > 80.0) {
                            X2 = BetaRejectionLoglogisticGen.equalsDouble(this.am, this.p) ? 1.0 : 0.0;
                            break block0;
                        }
                        w = this.am * Math.exp(v);
                        X2 = !BetaRejectionLoglogisticGen.equalsDouble(this.am, this.p) ? this.bm / (this.bm + w) : w / (this.bm + w);
                        break block0;
                    }
                    if (z >= this.rk2) continue;
                    v = this.be * Math.log(u1 / (1.0 - u1));
                    if (v > 80.0) {
                        if (this.alnam < Math.log(z)) continue;
                        X2 = BetaRejectionLoglogisticGen.equalsDouble(this.am, this.p) ? 1.0 : 0.0;
                        break block0;
                    }
                    w = this.am * Math.exp(v);
                    if (!(this.al * (Math.log(this.al / (this.bm + w)) + v) - 1.386294361 < Math.log(z))) break;
                }
                X2 = !BetaRejectionLoglogisticGen.equalsDouble(this.am, this.p) ? this.bm / (this.bm + w) : w / (this.bm + w);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this.a + (this.b - this.a) * X2;
    }

    private static boolean equalsDouble(double a, double b) {
        if (a == b) {
            return true;
        }
        double absa = Math.abs(a);
        double absb = Math.abs(b);
        return Math.abs(a - b) <= Math.min(absa, absb) * 2.220446049250313E-16;
    }
}

