/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.randvar.BetaGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class BetaStratifiedRejectionGen
extends BetaGen {
    private RandomStream auxStream;
    private int gen;
    private static final int b00 = 2;
    private static final int b01 = 3;
    private static final int b01inv = 4;
    private static final int b1prs = 5;
    private double pint;
    private double qint;
    private double p_;
    private double q_;
    private double c;
    private double t;
    private double fp;
    private double fq;
    private double ml;
    private double mu;
    private double p1;
    private double p2;
    private double s;
    private double m;
    private double D;
    private double Dl;
    private double x1;
    private double x2;
    private double x4;
    private double x5;
    private double f1;
    private double f2;
    private double f4;
    private double f5;
    private double ll;
    private double lr;
    private double z2;
    private double z4;
    private double p3;
    private double p4;

    public BetaStratifiedRejectionGen(RandomStream s, RandomStream aux, double alpha, double beta) {
        super(s, null);
        this.auxStream = aux;
        this.setParams(alpha, beta, 0.0, 1.0);
        this.init();
    }

    public BetaStratifiedRejectionGen(RandomStream s, double alpha, double beta) {
        this(s, s, alpha, beta);
    }

    public BetaStratifiedRejectionGen(RandomStream s, RandomStream aux, double alpha, double beta, double a, double b) {
        super(s, null);
        this.auxStream = aux;
        this.setParams(alpha, beta, a, b);
        this.init();
    }

    public BetaStratifiedRejectionGen(RandomStream s, double alpha, double beta, double a, double b) {
        this(s, s, alpha, beta, a, b);
    }

    public BetaStratifiedRejectionGen(RandomStream s, RandomStream aux, BetaDist dist) {
        super(s, dist);
        this.auxStream = aux;
        if (dist != null) {
            this.setParams(dist.getAlpha(), dist.getBeta(), dist.getA(), dist.getB());
        }
        this.init();
    }

    public BetaStratifiedRejectionGen(RandomStream s, BetaDist dist) {
        this(s, s, dist);
    }

    public RandomStream getAuxStream() {
        return this.auxStream;
    }

    public double nextDouble() {
        double X2 = 0.0;
        RandomStream stream = this.stream;
        block0 : switch (this.gen) {
            case 2: {
                while (true) {
                    double V;
                    double Z;
                    double U = stream.nextDouble() * this.p2;
                    stream = this.auxStream;
                    if (U <= this.p1) {
                        Z = Math.exp(Math.log(U / this.p1) / this.p);
                        X2 = this.t * Z;
                        V = stream.nextDouble() * this.fq;
                        if (!(V <= 1.0 - this.q_ * X2) && (!(V <= 1.0 + (this.fq - 1.0) * Z) || !(Math.log(V) <= this.q_ * Math.log(1.0 - X2)))) continue;
                        break block0;
                    }
                    Z = Math.exp(Math.log((U - this.p1) / (this.p2 - this.p1)) / this.q);
                    X2 = 1.0 - (1.0 - this.t) * Z;
                    V = stream.nextDouble() * this.fp;
                    if (V <= 1.0 - this.p_ * (1.0 - X2) || V <= 1.0 + (this.fp - 1.0) * Z && Math.log(V) <= this.p_ * Math.log(X2)) break;
                }
                break;
            }
            case 3: 
            case 4: {
                while (true) {
                    double V;
                    double Z;
                    double U = stream.nextDouble() * this.p2;
                    stream = this.auxStream;
                    if (U <= this.p1) {
                        Z = Math.exp(Math.log(U / this.p1) / this.pint);
                        X2 = this.t * Z;
                        V = stream.nextDouble();
                        if (!(V <= 1.0 - this.ml * X2) && (!(V <= 1.0 - this.mu * Z) || !(Math.log(V) <= this.q_ * Math.log(1.0 - X2)))) continue;
                        break;
                    }
                    Z = Math.exp(Math.log((U - this.p1) / (this.p2 - this.p1)) / this.qint);
                    X2 = 1.0 - (1.0 - this.t) * Z;
                    V = stream.nextDouble() * this.fp;
                    if (V <= 1.0 - this.p_ * (1.0 - X2) || V <= 1.0 + (this.fp - 1.0) * Z && Math.log(V) <= this.p_ * Math.log(X2)) break;
                }
                if (!(this.p > this.q)) break;
                X2 = 1.0 - X2;
                break;
            }
            case 5: {
                while (true) {
                    double Y;
                    double V;
                    double W;
                    double U = stream.nextDouble() * this.p4;
                    stream = this.auxStream;
                    if (U <= this.p1) {
                        W = U / this.Dl - this.f2;
                        if (W <= 0.0) {
                            X2 = this.m - U / this.f2;
                            break block0;
                        }
                        if (W <= this.f1) {
                            X2 = this.x2 - W / this.f1 * this.Dl;
                            break block0;
                        }
                        U = stream.nextDouble();
                        V = this.Dl * U;
                        X2 = this.x2 - V;
                        Y = this.x2 + V;
                        if (W * (this.x2 - this.z2) <= this.f2 * (X2 - this.z2)) break block0;
                        V = this.f2 + this.f2 - W;
                        if (V < 1.0) {
                            if (V <= this.f2 + (1.0 - this.f2) * U) {
                                X2 = Y;
                                break block0;
                            }
                            if (V <= Math.exp(this.p_ * Math.log(Y / this.m) + this.q_ * Math.log((10.0 - Y) / (1.0 - this.m)))) {
                                X2 = Y;
                                break block0;
                            }
                        }
                    } else if (U <= this.p2) {
                        W = (U -= this.p1) / this.D - this.f4;
                        if (W <= 0.0) {
                            X2 = this.m + U / this.f4;
                            break block0;
                        }
                        if (W <= this.f5) {
                            X2 = this.x4 + W / this.f5 * this.D;
                            break block0;
                        }
                        U = stream.nextDouble();
                        V = this.D * U;
                        X2 = this.x4 + V;
                        Y = this.x4 - V;
                        if (W * (this.z4 - this.x4) <= this.f4 * (this.z4 - X2)) break block0;
                        V = this.f4 + this.f4 - W;
                        if (V < 1.0) {
                            if (V <= this.f4 + (1.0 - this.f4) * U) {
                                X2 = Y;
                                break block0;
                            }
                            if (V <= Math.exp(this.p_ * Math.log(Y / this.m) + this.q_ * Math.log((1.0 - Y) / (1.0 - this.m)))) {
                                X2 = Y;
                                break block0;
                            }
                        }
                    } else if (U <= this.p3) {
                        Y = Math.log(U = (U - this.p2) / (this.p3 - this.p2));
                        X2 = this.x1 + this.ll * Y;
                        if (X2 <= 0.0) continue;
                        W = U * stream.nextDouble();
                        if (W <= 1.0 + Y) break block0;
                        W *= this.f1;
                    } else {
                        Y = Math.log(U = (U - this.p3) / (this.p4 - this.p3));
                        X2 = this.x5 - this.lr * Y;
                        if (X2 >= 1.0) continue;
                        W = U * stream.nextDouble();
                        if (W <= 1.0 + Y) break block0;
                        W *= this.f5;
                    }
                    if (Math.log(W) <= this.p_ * Math.log(X2 / this.m) + this.q_ * Math.log((1.0 - X2) / (1.0 - this.m))) break;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this.gen == 4 ? this.a + (this.b - this.a) * (1.0 - X2) : this.a + (this.b - this.a) * X2;
    }

    public static double nextDouble(RandomStream s, double alpha, double beta, double a, double b) {
        return BetaDist.inverseF(alpha, beta, a, b, 15, s.nextDouble());
    }

    private void init() {
        if (this.p > 1.0) {
            if (this.q > 1.0) {
                this.gen = 5;
            } else {
                this.gen = 4;
                double temp = this.p;
                this.p = this.q;
                this.q = temp;
            }
        } else {
            this.gen = this.q > 1.0 ? 3 : 2;
        }
        switch (this.gen) {
            case 2: {
                this.p_ = this.p - 1.0;
                this.q_ = this.q - 1.0;
                this.c = this.q * this.q_ / (this.p * this.p_);
                this.t = this.c == 1.0 ? 0.5 : (1.0 - Math.sqrt(this.c)) / (1.0 - this.c);
                this.fp = Math.exp(this.p_ * Math.log(this.t));
                this.fq = Math.exp(this.q_ * Math.log(1.0 - this.t));
                this.p1 = this.t / this.p;
                this.p2 = (1.0 - this.t) / this.q + this.p1;
                break;
            }
            case 3: 
            case 4: {
                if (this.p > this.q) {
                    this.pint = this.q;
                    this.qint = this.p;
                } else {
                    this.pint = this.p;
                    this.qint = this.q;
                }
                this.p_ = this.pint - 1.0;
                this.q_ = this.qint - 1.0;
                this.t = this.p_ / (this.pint - this.qint);
                this.fq = Math.exp((this.q_ - 1.0) * Math.log(1.0 - this.t));
                this.fp = this.pint - (this.pint + this.q_) * this.t;
                this.t -= (this.t - (1.0 - this.fp) * (1.0 - this.t) * this.fq / this.qint) / (1.0 - this.fp * this.fq);
                this.fp = Math.exp(this.p_ * Math.log(this.t));
                this.fq = Math.exp(this.q_ * Math.log(1.0 - this.t));
                if (this.q_ <= 1.0) {
                    this.ml = (1.0 - this.fq) / this.t;
                    this.mu = this.q_ * this.t;
                } else {
                    this.ml = this.q_;
                    this.mu = 1.0 - this.fq;
                }
                this.p1 = this.t / this.pint;
                this.p2 = this.fq * (1.0 - this.t) / this.qint + this.p1;
                break;
            }
            case 5: {
                this.p_ = this.p - 1.0;
                this.q_ = this.q - 1.0;
                this.s = this.p_ + this.q_;
                this.m = this.p_ / this.s;
                if (this.p_ > 1.0 || this.q_ > 1.0) {
                    this.D = Math.sqrt(this.m * (1.0 - this.m) / (this.s - 1.0));
                }
                if (this.p_ <= 1.0) {
                    this.x2 = this.Dl = this.m * 0.5;
                    this.ll = 0.0;
                    this.f1 = 0.0;
                    this.z2 = 0.0;
                    this.x1 = 0.0;
                } else {
                    this.x2 = this.m - this.D;
                    this.x1 = this.x2 - this.D;
                    this.z2 = this.x2 * (1.0 - (1.0 - this.x2) / (this.s * this.D));
                    if (this.x1 <= 0.0 || (this.s - 6.0) * this.x2 - this.p_ + 3.0 > 0.0) {
                        this.x1 = this.z2;
                        this.x2 = (this.x1 + this.m) * 0.5;
                        this.Dl = this.m - this.x2;
                    } else {
                        this.Dl = this.D;
                    }
                    this.f1 = Math.exp(this.p_ * Math.log(this.x1 / this.m) + this.q_ * Math.log((1.0 - this.x1) / (1.0 - this.m)));
                    this.ll = this.x1 * (1.0 - this.x1) / (this.s * (this.m - this.x1));
                }
                this.f2 = Math.exp(this.p_ * Math.log(this.x2 / this.m) + this.q_ * Math.log((1.0 - this.x2) / (1.0 - this.m)));
                if (this.q_ <= 1.0) {
                    this.D = (1.0 - this.m) * 0.5;
                    this.x4 = 1.0 - this.D;
                    this.z4 = 1.0;
                    this.x5 = 1.0;
                    this.lr = 0.0;
                    this.f5 = 0.0;
                } else {
                    this.x4 = this.m + this.D;
                    this.x5 = this.x4 + this.D;
                    this.z4 = this.x4 * (1.0 + (1.0 - this.x4) / (this.s * this.D));
                    if (this.x5 >= 1.0 || (this.s - 6.0) * this.x4 - this.p_ + 3.0 < 0.0) {
                        this.x5 = this.z4;
                        this.x4 = (this.m + this.x5) * 0.5;
                        this.D = this.x4 - this.m;
                    }
                    this.f5 = Math.exp(this.p_ * Math.log(this.x5 / this.m) + this.q_ * Math.log((1.0 - this.x5) / (1.0 - this.m)));
                    this.lr = this.x5 * (1.0 - this.x5) / (this.s * (this.x5 - this.m));
                }
                this.f4 = Math.exp(this.p_ * Math.log(this.x4 / this.m) + this.q_ * Math.log((1.0 - this.x4) / (1.0 - this.m)));
                this.p1 = this.f2 * (this.Dl + this.Dl);
                this.p2 = this.f4 * (this.D + this.D) + this.p1;
                this.p3 = this.f1 * this.ll + this.p2;
                this.p4 = this.f5 * this.lr + this.p3;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static boolean equalsDouble(double a, double b) {
        if (a == b) {
            return true;
        }
        double absa = Math.abs(a);
        double absb = Math.abs(b);
        return Math.abs(a - b) <= Math.min(absa, absb) * 2.220446049250313E-16;
    }
}

