/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import cern.colt.list.DoubleArrayList;
import umontreal.iro.lecuyer.probdist.Distribution;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class RandomVariateGenWithCache
extends RandomVariateGen {
    private RandomVariateGen rvg;
    private DoubleArrayList values;
    private int index = 0;
    private boolean caching = true;

    public RandomVariateGenWithCache(RandomVariateGen rvg) {
        if (rvg == null) {
            throw new NullPointerException("The given random variate generator cannot be null");
        }
        this.rvg = rvg;
        this.values = new DoubleArrayList();
    }

    public RandomVariateGenWithCache(RandomVariateGen rvg, int initialCapacity) {
        if (rvg == null) {
            throw new NullPointerException("The given random variate generator cannot be null");
        }
        this.rvg = rvg;
        this.values = new DoubleArrayList(initialCapacity);
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        if (this.caching && !caching) {
            this.clearCache();
        }
        this.caching = caching;
    }

    public RandomVariateGen getCachedGen() {
        return this.rvg;
    }

    public void setCachedGen(RandomVariateGen rvg) {
        if (rvg == null) {
            throw new NullPointerException("The given random variate generator cannot be null");
        }
        if (rvg == this.rvg) {
            return;
        }
        this.rvg = rvg;
        this.clearCache();
    }

    public void clearCache() {
        this.values = new DoubleArrayList();
        this.index = 0;
    }

    public void initCache() {
        this.index = 0;
    }

    public int getNumCachedValues() {
        return this.values.size();
    }

    public int getCacheIndex() {
        return this.index;
    }

    public void setCacheIndex(int newIndex) {
        if (newIndex < 0 || newIndex > this.values.size()) {
            throw new IllegalArgumentException("newIndex must not be negative or greater than the cache size");
        }
        this.index = newIndex;
    }

    public DoubleArrayList getCachedValues() {
        return this.values;
    }

    public void setCachedValues(DoubleArrayList values2) {
        if (values2 == null) {
            throw new NullPointerException();
        }
        this.values = values2;
        this.index = values2.size();
    }

    public double nextDouble() {
        if (!this.caching) {
            return this.rvg.nextDouble();
        }
        if (this.index >= this.values.size()) {
            double v = this.rvg.nextDouble();
            this.values.add(v);
            ++this.index;
            return v;
        }
        return this.values.getQuick(this.index++);
    }

    public void nextArrayOfDouble(double[] v, int start, int n) {
        int ngen;
        int ncpy;
        if (!this.caching) {
            this.rvg.nextArrayOfDouble(v, start, n);
            return;
        }
        int remainingValues = this.values.size() - this.index;
        if (remainingValues < 0) {
            remainingValues = 0;
        }
        if ((ncpy = Math.min(n, remainingValues)) > 0) {
            System.arraycopy(this.values.elements(), this.index, v, start, ncpy);
            this.index += ncpy;
        }
        if ((ngen = n - ncpy) > 0) {
            this.rvg.nextArrayOfDouble(v, start + ncpy, ngen);
            for (int i = ncpy; i < n; ++i) {
                this.values.add(v[start + i]);
                ++this.index;
            }
        }
    }

    public RandomStream getStream() {
        return this.rvg.getStream();
    }

    public Distribution getDistribution() {
        return this.rvg.getDistribution();
    }
}

