/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.simprocs.ProcessSimulator;
import umontreal.iro.lecuyer.simprocs.SimProcess;
import umontreal.iro.lecuyer.simprocs.SimThread;

public class ThreadProcessSimulator
extends ProcessSimulator {
    private SimThread threadAllHead = null;

    public void init() {
        super.init();
    }

    public void init(EventList evlist) {
        super.init(evlist);
    }

    public SimThread createControlEvent(SimProcess process) {
        return SimThread.getThread(process, this);
    }

    public void delay(SimProcess process, double delay) {
        if (this.currentProcess != process) {
            throw new IllegalStateException("Calling delay() for a process not in EXECUTING state");
        }
        if (delay < 0.0) {
            throw new IllegalArgumentException("Calling delay() with negative delay");
        }
        process.scheduledEvent().schedule(delay);
        this.dispatch();
        ((SimThread)process.scheduledEvent()).passivate();
    }

    public void suspend(SimProcess process) {
        SimThread ev = (SimThread)process.scheduledEvent();
        if (ev == null) {
            throw new IllegalStateException("Calling suspend() for a dead process");
        }
        if (this.currentProcess == process) {
            this.dispatch();
            ev.passivate();
            return;
        }
        if (ev.time() >= 0.0) {
            ev.cancel();
            ev.setTime(-10.0);
            return;
        }
        if (ev.time() == -20.0) {
            throw new IllegalStateException("Calling suspend() for a process in INITIAL state");
        }
        throw new IllegalStateException("Calling suspend() for a suspended process");
    }

    public void kill(SimProcess process) {
        if (process.scheduledEvent() == null) {
            throw new IllegalStateException("cannot kill a DEAD process");
        }
        ((SimThread)process.scheduledEvent()).kill();
    }

    public void killAll() {
        SimThread.killAll(this);
    }

    protected void dispatch() {
        Event ev;
        while ((ev = this.removeFirstEvent()) != null) {
            if (ev instanceof SimThread) {
                this.currentProcess = ((SimThread)ev).myProcess;
                ((SimThread)ev).activate();
                return;
            }
            ev.actions();
        }
        SimThread.simActivate(this);
    }

    protected SimThread threadAllHead() {
        return this.threadAllHead;
    }

    protected void setThreadAllHead(SimThread thread2) {
        this.threadAllHead = thread2;
    }
}

