/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util.io;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import umontreal.iro.lecuyer.util.io.AbstractDataWriter;

public class BinaryDataWriter
extends AbstractDataWriter {
    protected DataOutputStream out;
    public static final byte TYPECHAR_LABEL = 124;
    public static final byte TYPECHAR_STRING = 83;
    public static final byte TYPECHAR_INTEGER = 105;
    public static final byte TYPECHAR_FLOAT = 102;
    public static final byte TYPECHAR_DOUBLE = 100;

    protected void writeStringData(String s) throws IOException {
        if (s != null) {
            this.out.writeInt(s.length());
            this.out.writeBytes(s);
        } else {
            this.out.writeInt(0);
        }
    }

    protected void writeLabel(String label) throws IOException {
        this.out.writeByte(124);
        this.writeStringData(label);
    }

    public BinaryDataWriter(String filename, boolean append) throws IOException {
        this.out = new DataOutputStream(new FileOutputStream(filename, append));
    }

    public BinaryDataWriter(File file, boolean append) throws IOException {
        this.out = new DataOutputStream(new FileOutputStream(file, append));
    }

    public BinaryDataWriter(String filename) throws IOException {
        this.out = new DataOutputStream(new FileOutputStream(filename));
    }

    public BinaryDataWriter(File file) throws IOException {
        this.out = new DataOutputStream(new FileOutputStream(file));
    }

    public BinaryDataWriter(OutputStream outputStream2) throws IOException {
        this.out = new DataOutputStream(outputStream2);
    }

    public void write(String label, String s) throws IOException {
        this.writeLabel(label);
        this.out.writeByte(83);
        this.out.writeByte(0);
        this.writeStringData(s);
    }

    public void write(String label, int a) throws IOException {
        this.writeLabel(label);
        this.out.writeByte(105);
        this.out.writeByte(0);
        this.out.writeInt(a);
    }

    public void write(String label, float a) throws IOException {
        this.writeLabel(label);
        this.out.writeByte(102);
        this.out.writeByte(0);
        this.out.writeFloat(a);
    }

    public void write(String label, double a) throws IOException {
        this.writeLabel(label);
        this.out.writeByte(100);
        this.out.writeByte(0);
        this.out.writeDouble(a);
    }

    public void write(String label, String[] a, int n) throws IOException {
        this.writeLabel(label);
        this.out.writeByte(83);
        this.out.writeByte(1);
        this.out.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeStringData(a[i]);
        }
    }

    public void write(String label, int[] a, int n) throws IOException {
        this.writeLabel(label);
        this.out.writeByte(105);
        this.out.writeByte(1);
        this.out.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.out.writeInt(a[i]);
        }
    }

    public void write(String label, float[] a, int n) throws IOException {
        this.writeLabel(label);
        this.out.writeByte(102);
        this.out.writeByte(1);
        this.out.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.out.writeFloat(a[i]);
        }
    }

    public void write(String label, double[] a, int n) throws IOException {
        this.writeLabel(label);
        this.out.writeByte(100);
        this.out.writeByte(1);
        this.out.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.out.writeDouble(a[i]);
        }
    }

    public void write(String label, String[][] a) throws IOException {
        this.writeLabel(label);
        this.out.writeByte(83);
        this.out.writeByte(2);
        this.out.writeInt(a.length);
        this.out.writeInt(a[0].length);
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                this.writeStringData(a[i][j]);
            }
        }
    }

    public void write(String label, int[][] a) throws IOException {
        this.writeLabel(label);
        this.out.writeByte(105);
        this.out.writeByte(2);
        this.out.writeInt(a.length);
        this.out.writeInt(a[0].length);
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                this.out.writeInt(a[i][j]);
            }
        }
    }

    public void write(String label, float[][] a) throws IOException {
        this.writeLabel(label);
        this.out.writeByte(102);
        this.out.writeByte(2);
        this.out.writeInt(a.length);
        this.out.writeInt(a[0].length);
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                this.out.writeFloat(a[i][j]);
            }
        }
    }

    public void write(String label, double[][] a) throws IOException {
        this.writeLabel(label);
        this.out.writeByte(100);
        this.out.writeByte(2);
        this.out.writeInt(a.length);
        this.out.writeInt(a[0].length);
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                this.out.writeDouble(a[i][j]);
            }
        }
    }

    public void close() throws IOException {
        this.out.close();
    }
}

